<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Tables\User;

use Erlage\Photogram\Data\Tables\AbstractTable;
use Erlage\Photogram\Data\Common\CommonTransformer;
use Erlage\Photogram\Data\Models\User\Recovery\UserRecoveryModel;

final class UserRecoveryTable extends AbstractTable
{
    /*
    |--------------------------------------------------------------------------
    | table data
    |--------------------------------------------------------------------------
    */

    const TABLE_NAME = 'userrecovery';

    /*
    |--------------------------------------------------------------------------
    | fields/attributes
    |--------------------------------------------------------------------------
    */

    // ids

    const ID = 'id';

    // ids

    const USER_ID = 'user_id';

    // meta

    const META_ACCESS_OTP = 'meta_access_otp';

    const META_ACCESS_TOKEN = 'meta_access_token';

    const META_TIMES_FAILED = 'meta_times_failed';

    const META_IS_EXPIRED = 'meta_is_expired';

    // stamps

    const STAMP_REGISTRATION = 'stamp_registration';

    const STAMP_LAST_UPDATE = 'stamp_last_update';

    /**
     * 
     * User's account recovery process:
     * 
     *  1. Users asks for recovery
     *  2. Server generates a 'userrecovery' entry
     *  3. Server sends access_code to user'email
     *  4. User is asked to provide the sent access_code
     *  5. On correct code match, server sends access_token(one-time use only) to user
     *  6. User can use that access token to dispatch a change password request
     *  7. Password change request must log user out from all devices(unless user untick that)
     *     Can be acheived simply by generating new meta_access for user's row
     */

    /*
    |--------------------------------------------------------------------------
    | all properties must provide their camel case equivalent
    |--------------------------------------------------------------------------
    */

    const CAMEL_CASE_MAP = array(
        self::ID                   => 'id',

        self::USER_ID              => 'userId',

        self::META_ACCESS_OTP      => 'metaAccessOTP',
        self::META_ACCESS_TOKEN    => 'metaAccessToken',
        self::META_TIMES_FAILED    => 'metaTimesFailed',
        self::META_IS_EXPIRED      => 'metaIsExpired',

        self::STAMP_REGISTRATION   => 'stampRegistration',
        self::STAMP_LAST_UPDATE    => 'stampLastUpdate',
    );

    /*
    |--------------------------------------------------------------------------
    | required attributes
    |--------------------------------------------------------------------------
    */

    public static function getPrimaryAttribute(): string
    {
        return self::ID;
    }

    public static function getRegistrationStampAttribute(): string
    {
        return self::STAMP_REGISTRATION;
    }

    public static function getLastUpdateStampAttribute(): string
    {
        return self::STAMP_LAST_UPDATE;
    }

    public static function getOwnerAttribute(): string
    {
        return self::USER_ID;
    }

    /*
    |--------------------------------------------------------------------------
    | meta getters
    |--------------------------------------------------------------------------
    */

    public static function getTableName(): string
    {
        return self::TABLE_NAME;
    }

    public static function getModelClassName(): string
    {
        return UserRecoveryModel::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | table properties getters
    |--------------------------------------------------------------------------
    */

    public static function allAttributes(): array
    {
        return self::CAMEL_CASE_MAP;
    }

    public static function protectedAttributes(): array
    {
        return array(
            self::META_ACCESS_OTP    => self::CAMEL_CASE_MAP[self::META_ACCESS_OTP],
            self::META_TIMES_FAILED  => self::CAMEL_CASE_MAP[self::META_TIMES_FAILED],
            self::META_IS_EXPIRED    => self::CAMEL_CASE_MAP[self::META_IS_EXPIRED],

            self::STAMP_LAST_UPDATE  => self::CAMEL_CASE_MAP[self::STAMP_LAST_UPDATE],
            self::STAMP_REGISTRATION => self::CAMEL_CASE_MAP[self::STAMP_REGISTRATION],
        );
    }

    /*
    |--------------------------------------------------------------------------
    | table modifiers
    |--------------------------------------------------------------------------
    */

    public static function transformers(): array
    {
        return array(
            self::META_ACCESS_OTP   => array(CommonTransformer::erlClass(), self::CAMEL_CASE_MAP[self::META_ACCESS_OTP]),
            self::META_ACCESS_TOKEN => array(CommonTransformer::erlClass(), self::CAMEL_CASE_MAP[self::META_ACCESS_TOKEN]),
        );
    }
}
